﻿var emailDistributionWizard = {
    context: $(".v-emailWizard"),
    htmlRegEx: /href=\"[^"]*\"/gim,
    initialize: function () {
        var self = this;

        emailDistributionWizard.toggleConditionalTemplateTable();

        emailDistributionWizard.currentTemplate = { HTMLBody: $("#HtmlBody").val() };
        $("#HtmlBody").a4richTextEditor({
            library: true, piping: true, piping_distribute: true,
            embed_questions: surveyMenu.survey.UseS2, readonly: true, fullPage: true, height: 250
        });
        $("#HtmlBody").a4richTextEditor("setContent", this.currentTemplate.HTMLBody);

        $(".v-templatesAutocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetEmailTemplatesForAutoComplete", "Distribute"),
            select: function (event, data) {
                if (data.item) {
                    a4.callServerMethod(a4.getSurveyAction("GetEmailTemplate", "Distribute"), {
                        id: data.item.Value
                    }, function (result) {
                        self.currentTemplate = result;
                        self.loadTemplate(result);
                        self.disableMessage(true);
                    });
                }
                else {
                    self.clearTemplate();
                    self.disableMessage();
                }
            }
        });

        a4.callServerMethod(a4.getSurveyAction("GetOutgoingMailConfigurationsForAutoComplete", "Distribute", { surveyId: $("#SurveyId").val() }), {}, function (result) {
            var outgoingMailConfigurationId = $("#OutgoingMailConfigurationId", this.context).val();
            if (outgoingMailConfigurationId) {
                result.forEach(function (config, i) {
                    if (config.Id === +outgoingMailConfigurationId) {
                        result.splice(i, 1);
                        result.unshift(config);
                    }
                });
            }
            var outgoingMailInput = $(".v-outgoingMailConfigsAutocomplete", this.context).a4autocomplete({
                data: result,
                valueProperty: "Id",
                labelProperty: "DisplayName",
                select: function (event, data) {
                    if (data.item) {
                        var selectedOutgoingConfigId = data.item.Id;
                        $("#OutgoingMailConfigurationId").val(selectedOutgoingConfigId);

                        // re-initialize sender email autocomplete input with selected outgoing mail configuration
                        $(".v-senderEmailsAutocomplete", this.context).a4autocomplete({
                            ajaxAction: a4.getSurveyAction("GetSenderEmailAddressesForAutoComplete", "Distribute", { outgoingMailConfigurationId: selectedOutgoingConfigId }),
                            validateSelection: false,
                            displayDeleteItem: true,
                            deleteItem: function (event, data) {
                                var self = $(this);

                                if (data.item) {
                                    modalDialog.showConfirmDialog(confirmDeleteSenderResources, function () {
                                        a4.callServerMethod(a4.getSurveyAction("DeleteSenderEmailAddress", "Distribute"), {
                                            address: data.item.Value,
                                            outgoingMailConfigurationId: selectedOutgoingConfigId
                                        }, function (result) {
                                            self.a4autocomplete("clearCache");
                                        });
                                    }, null, null, false, { "email": data.item.Value });
                                }
                            }
                        });
                    }
                },
                required: true
            });
            a4.setInputValue(outgoingMailInput);
        });

        // clear sender email when outgoing mail configuration selection changes
        $(".v-outgoingMailConfigsAutocomplete", this.context).on("change", function () {
            a4.setInputValue($(".v-senderEmailsAutocomplete", this.context), "");
        });

        var useTemplate = $(".h-useTemplate:checked", this.context).val() == "False";

        if (useTemplate) {
            var templateSelected = $("#TemplateId", this.context).val() != "";
            var editEnabled = $("#Disabled", this.context).val() != "True";

            this.disableMessage(templateSelected && editEnabled);
        }

        $(".v-conditionalTemplates tbody tr", self.context).each(function () {
            self.setConditionalTemplateAutocomplete($(this));
        });

        $(".page:not(:first)").hide();

        this.toggleAccessExpirationSection($(".h-accessExpiration-select", self.context), false);
    },
    bindEvents: function () {
        var self = this;
        var context = this.context;

        context.on("change", ".h-useTemplate", function () {
            var createTemplate = $(this).val() == "True";

            self.clearTemplate();
            $(".v-createNewTemplate", context).toggle(createTemplate)
            $(".v-selectTemplate", context).toggle(!createTemplate)

            if (createTemplate) {
                self.enableMessage();
                self.disableWizardNavigation(false);

                if ($(".v-template-unsavedChanges", self.context).attr("data-tracking-changes"))
                    $(".v-template-unsavedChanges", self.context).a4unsavedChanges("destroy"); //Ignore saved changes if using create template
            }
            else {
                self.disableMessage();

                if ($("#TemplateId", this.context).val() == "") {
                    self.disableWizardNavigation(true);
                }
            }
        });

        context.on("change", ".h-useBatch", function () {
            var useBatch = $(this).val() == "True";
            $(".v-useBatchDiv", context).toggle(useBatch);
            if (useBatch) {
                $(".v-submit-button").addClass("hidden");
            } else {
                $(".v-submit-button").removeClass("hidden");
                $(".v-batchConfigs").val("");
            }
        });

        context.on("click", ".h-editTemplate", function () {
            $(".v-saveTemplateContainer", context).show();
            self.disableWizardNavigation(true);
            self.enableMessage(true);
            self.enableUnsavedChanges();
        });

        context.on("click", ".h-cancelTemplate", function () {
            $(this).closest(".v-saveTemplateContainer").hide();
            self.loadTemplate(self.currentTemplate);
            self.disableWizardNavigation(false);
            self.disableMessage(true);
        });

        context.on("click", ".h-saveTemplate", function () {
            modalDialog.showConfirmDialog(confirmOverwriteTemplateResources, function () {
                $(this).closest(".v-saveTemplateContainer").hide();
                self.saveTemplate();
            }, 250, 500, true, { "name": self.currentTemplate.Name });
        });

        context.on("click", ".h-emailContentTypeSelector li", function () {
            var typeSelector = $(this).closest(".h-emailContentTypeSelector");
            var container = typeSelector.parent();
            var contentEditor = $(this).attr("data-editor");

            $("li.selected", typeSelector).removeClass("selected");
            $(this).addClass("selected");

            container.children(".v-contentContainer").hide();
            $(".v-contentContainer[data-editor='" + contentEditor + "']", container).show();

            $(".v-content-error", context).removeClass("field-validation-error");
            $(".v-textAreaContent", context).removeClass("input-validation-error");
            $(".v-content-error", context).html("");
        });

        context.on("change", "#TextBody, #HtmlBody", function () {
            var textContent = $("#TextBody", context).val().trim();
            var htmlContent = $("#HtmlBody", context).val().trim();

            if (textContent == "" && htmlContent == "") {
                $(".v-textAreaContent").addClass("v-requiredField");
            }
            else {
                $(".v-textAreaContent", context).removeClass("v-requiredField");
                $(".v-textAreaContent", context).removeClass("input-validation-error");
                $(".v-content-error", context).removeClass("field-validation-error");
                $(".v-content-error", context).html("");
            }
        });

        context.on("click", ".h-createRecipientList", function () {
            modalDialog.showWindow(a4.getSurveyAction("CreateRecipientList", "Distribute"), 550, 600, { afterClose: function () { emailDistributionWizard.reloadRecipientLists(); } });
        });

        context.on("click", ".h-useSample:not(.disabled)", function () {
            
            $("#RespondentFilterDefinition").val($("#RespondentFilter", emailDistributionWizard.context).val());

            modalDialog.showWindow(a4.getSurveyAction("RespondentFilter", "Shared", {
                respondentFilter:  "", forDistributions: true, excludeEmptyEmails: true, excludeEmptyPhones: false
            }), 785, 1050);
        });

        context.on("change", ".h-schedule-select", function () {
            var container = $(this).closest(".field");
            var scheduleType = $(this).val();

            $(".v-specificSchedule", container).toggle($(this).val() == "Specific");

            var date = new Date();

            if (scheduleType == "Tomorrow") {
                date.setDate(date.getDate() + 1);
            }
            else if (scheduleType == "NextWeek") {
                date.setDate(date.getDate() + 7);
            }
            else if (scheduleType == "NotScheduled") {
                date = "";
            }

            $(".datetime", container).datetimepicker("setDate", date);
        });

        context.on("change", "#CreateReminder", function () {
            $(".v-reminderSchedule", context).toggle($(this).is(":checked"));
        });

        context.on("click", ".h-addConditionalTemplate:not(.disabled)", function () {
            var table = $(".v-conditionalTemplates", context);
            var row = $("tfoot .v-templateConditionRow", table).clone();
            var index = $("tbody tr", table).length;
            var modelName = table.attr("data-name");

            $("tbody", table).append(row);

            self.setConditionalTemplateAutocomplete(row);
            self.setConditionalTemplateInputs(modelName, index, row);
            self.toggleConditionalTemplateTable();
        });

        $(".v-conditionalTemplates:not(.disabled)", context).on("click", ".h-deleteRow", function () {
            var row = $(this).closest("tr");
            row.remove();
            self.reindexConditionalTemplateTable();
            self.toggleConditionalTemplateTable();
        });

        $(".v-conditionalTemplates:not(.disabled)", context).on("click", ".h-moveRowUp", function () {
            var item = $(this).closest(".v-templateConditionRow");
            var previous = item.prevAll(".v-templateConditionRow:visible:first");

            if (previous.length > 0) {
                item.insertBefore(previous);
                self.reindexConditionalTemplateTable();
            }
        });

        $(".v-conditionalTemplates:not(.disabled)", context).on("click", ".h-moveRowDown", function () {
            var item = $(this).closest(".v-templateConditionRow");
            var next = item.nextAll(".v-templateConditionRow:visible:first");

            if (next.length > 0) {
                item.insertAfter(next);
                self.reindexConditionalTemplateTable();
            }
        });

        context.on("change", ".h-recipientType", function () {
            self.toggleRecipientTypeSection($(this));
        });

        context.on("change", ".h-accessExpiration-select", function () {
            self.toggleAccessExpirationSection($(this), true);

            var useAccessExpiration = $(".v-useAccessExpiration", $(this).closest(".v-useAccessExpirationContainer"));
            $(".field-validation-error", useAccessExpiration).hide();
            $(".h-accessExpirationValue", useAccessExpiration).removeClass("input-validation-error");
        });

        context.on("keydown", "#EmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-count", parent).text(a4.countEmails($(this).val()));
        });

        context.on("change", "#EmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-count", parent).text(a4.countEmails($(this).val()));
        });

        context.on("keydown", "#NotificationEmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-notification-count", parent).text(a4.countEmails($(this).val()));
        });

        context.on("change", "#NotificationEmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-notification-count", parent).text(a4.countEmails($(this).val()));
        });

        context.on("change", ".h-schedule-select", function () {
            var container = $(this).closest(".field");
            var input = $(".v-specificSchedule input", container);
            a4.clearInputValidation(input);
        });

        context.on("change", "#Name", function () {
            var name = $(this).val();
            if ($("#NewTemplateName", context).val() == "") {
                $("#NewTemplateName", context).val(name);
            }
        });

        context.on("click", ".v-expirationCalendarIcon:not(.disabled)", function () {
            $("input.hasDatepicker", $(this).parent()).datepicker('show');
        });
    },
    toggleRecipientTypeSection: function (input) {
        var parent = input.closest(".v-recipientTypeContainer");
        var section = input.attr("data-section");
        $(".v-recipientTypeContainer", parent).hide();
        $(".v-recipientTypeContainer[data-section=" + section + "]", parent).show();
        if (section == "sample")
            $("#AdvancedOptions_UseExclusionList", parent).prop("checked", false);
        $(".v-useExclusionListContainer", parent).toggle(section != "sample");
    },
    toggleAccessExpirationSection: function (input, clearValue) {
        var expirationSection = input.closest(".v-useAccessExpirationContainer");
        var accessExpiration = $(".v-useAccessExpiration", expirationSection);

        var useAccessExpiration = (input.val() != "None");
        accessExpiration.toggle(useAccessExpiration);

        if (useAccessExpiration) {
            $(".h-accessExpirationLabel", accessExpiration).hide();
            $(".h-accessExpirationLabel[data-section=" + input.val().toLowerCase() + "]", accessExpiration).show();

            var valueField = $(".h-accessExpirationValue", accessExpiration);

            if (clearValue)
                valueField.val("");

            valueField.autoNumeric("destroy");
            valueField.datetimepicker("destroy");

            if (input.val() == "AbsoluteDate") {
                valueField.datetimepicker({ minDate: new Date() });
                valueField.next(".calendarIcon").show();
                valueField.attr('readonly', true);
                valueField.focus();
            } else {
                valueField.autoNumeric({ aSep: '', aDec: '.', aPad: false });
                valueField.next(".calendarIcon").hide();
                valueField.attr('readonly', false);
            }
        }
    },
    toggleConditionalTemplateTable: function () {
        var table = $(".v-conditionalTemplates", this.context);
        if ($("tbody tr", table).length > 0) {
            table.show();
        }
        else {
            table.hide();
        }
    },
    disableWizardNavigation: function (disable) {
        if (disable) {
            $(".h-next-button").attr("disabled", true);
            $(".h-prev-button").attr("disabled", true);
            $(".breadcrumb li", this.context).addClass("non-clickable");
        }
        else {
            $(".h-next-button").attr("disabled", false);
            $(".h-prev-button").attr("disabled", false);
            $(".breadcrumb li", this.context).removeClass("non-clickable");
        }
    },
    reindexConditionalTemplateTable: function () {
        var table = $(".v-conditionalTemplates", this.context);
        var modelName = table.attr("data-name");

        $("tbody tr", table).each(function (index) {
            emailDistributionWizard.setConditionalTemplateInputs(modelName, index, $(this));
        });
    },
    setConditionalTemplateInputs: function (modelName, index, row) {
        this.setConditionalTemplateInputName(modelName, index, $(".h-templateName", row));
        this.setConditionalTemplateInputName(modelName, index, $(".v-templateCondition", row));
        this.setConditionalTemplateInputName(modelName, index, $(".v-templateId", row));
        this.setConditionalTemplateInputName(modelName, index, $(".v-templatePosition", row));

        $(".v-templatePosition", row).val(index);
        $(".v-index", row).text(index + 1);
    },
    setConditionalTemplateInputName: function (modelName, index, input) {
        input.attr("name", modelName + "[" + index + "]." + input.attr("data-name"));
    },
    setConditionalTemplateAutocomplete: function (row) {
        $(".h-templateName", row).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetEmailTemplatesForAutoComplete", "Distribute"),
            select: function (event, data) {
                var value = data.item ? data.item.Value : undefined;
                $(".v-templateId", row).val(value);
            }
        });
    },
    reloadRecipientLists: function () {
        a4.callServerMethod(a4.getSurveyAction("GetRecipientLists", "Distribute"), {}, function (result) {
            var lists = JSON.parse(result);

            if (lists.length > 0) {
                var container = $(".recipient-list .checkbox-list", this.context);
                $(".list-item", container).remove();

                $.each(lists, function (index, value) {
                    var id = "RecipientList_" + (index + 1);
                    var input = $("<input />", { "id": id, "name": "RecipientList", "type": "checkbox", "value": value.Id });
                    var label = $("<label />", { "for": id }).text(value.Label);

                    container.append($("<div />", { "class": "list-item" }).append(input).append(label));
                });
            }
        });
    },
    canJumpToNextPage: function (page) {
        var pageIndex = page.attr("data-index");
        var recipientType = $(".h-recipientType:checked", this.context).val();

        if (pageIndex == "2" && recipientType == "RecipientLists") {
            if ($("#RecipientList input:checkbox:checked", this.context).length < 1) {
                var errorMessage = "<p style='margin-top: 5px;'><span id='mustCheckItemList' class='field-validation-error'>" +
                                        missingListSelectionMessage +
                                   "</span><p>";
                $("#RecipientList", this.context).after(errorMessage);
                return false;
            }
            else {
                $("#mustCheckItemList").remove();
                return true;
            }
        }

        return true;
    },
    updatePage: function (page) {
        var pageIndex = page.attr("data-index");

        if (pageIndex == 3) {
            var sender = $("#SenderName", this.context).val();
            var senderEmail = $("#SenderEmail", this.context).val();

            if (senderEmail.length > 0) {
                if (sender.length > 0) {
                    senderEmail = " (" + senderEmail + ")";
                }

                sender += senderEmail;
            }

            var recipientType = $(".h-recipientType:checked", this.context).val();
            var recipients;

            if (recipientType == "Addresses") {
                recipients = $("#EmailAddresses").val();

                if (recipients) {
                    recipients = _.compact(recipients.split(/[\n,;]/g));
                    recipients = recipients.join(", ");
                }
            }
            else if (recipientType == "Lists") {
                recipients = $("#RecipientList:checked", this.context).map(function () {
                    return $(this).attr("data-label");
                }).get();

                if (recipients.length > 0) {
                    recipients = recipients.join(", ");
                }
            }
            else {
                recipients = $(".v-sampleDetails").text();
            }

            if (!$("#ScheduleDate", this.context).val()) {
                $("#ScheduleDate", this.context).datetimepicker("setDate", new Date());
            }

            $(".v-previewSender", this.context).text(sender);
            $(".v-previewRecipient", this.context).text(recipients || "");
            $(".v-previewSubject", this.context).text($("#Subject", this.context).val());

            var previewHtml = a4.decodeHtml($("#HtmlBody", this.context).a4richTextEditor("getContent")).replace(emailDistributionWizard.htmlRegEx, "href=\"#\"");

            $(".v-previewBody", this.context).html(previewHtml);

            var sd = ($(".h-schedule-select").val() == "NotScheduled") ? $("#NotAvailable").val() : $("#ScheduleDate", this.context).val();
            $(".v-previewSendDate", this.context).text(sd);
        }
    },
    currentTemplate: null,
    enableMessage: function (edit) {
        $("#HtmlBody", this.context).a4richTextEditor("setContent", this.currentTemplate.HTMLBody);
        $("#HtmlBody", this.context).a4richTextEditor("enable");

        $("#Subject, #TextBody, #HtmlBody", this.context).prop("readonly", false);
        $(".v-saveTemplateContainer").toggle(edit || false);
        $(".v-editTemplateContainer").hide();
    },
    disableMessage: function (displayEdit) {
        $("#HtmlBody").a4richTextEditor("setContent", this.currentTemplate.HTMLBody.replace(emailDistributionWizard.htmlRegEx, "href=\"#\""));
        $("#HtmlBody", this.context).a4richTextEditor("disable");

        $("#Subject, #TextBody, #HtmlBody", this.context).prop("readonly", true);
        $(".v-saveTemplateContainer").hide();
        $(".v-editTemplateContainer").toggle(displayEdit || false);
    },
    loadTemplate: function (template) {
        if (template) {
            $("#TemplateId", this.context).val(template.Id);
            $("#Subject", this.context).val(template.Subject);
            $("#TextBody", this.context).val(template.TEXTBody);
            $("#HtmlBody").a4richTextEditor("setContent", template.HTMLBody.replace(emailDistributionWizard.htmlRegEx, "href=\"#\""));
            this.disableWizardNavigation(false);

            // display content
            $(".v-contentContainer", this.context).hide();
            $(".h-emailContentTypeSelector li.selected", this.context).removeClass("selected");

            if (template.HTMLBody != "" || template.TEXTBody == "") {
                $(".h-emailContentTypeSelector li[data-editor='html']", this.context).addClass("selected");
                $(".v-contentContainer[data-editor='html']", this.context).show();
            }
            else {
                $(".h-emailContentTypeSelector li[data-editor='text']", this.context).addClass("selected");
                $(".v-contentContainer[data-editor='text']", this.context).show();
            }
        }
    },
    clearTemplate: function () {
        $(".v-templatesAutocomplete", this.context).val("");
        $("#TemplateId", this.context).val("");
        $("#Subject", this.context).val("");
        $("#TextBody", this.context).val("");
        $("#HtmlBody").a4richTextEditor("setContent", "");
    },
    saveTemplate: function () {
        var templateId = $("#TemplateId", this.context).val();
        var name = $("#TemplateName", this.context).val();
        var subject = $("#Subject", this.context).val();
        var htmlBody = $("#HtmlBody", this.context).a4richTextEditor("getContent");
        var textBody = $("#TextBody", this.context).val();

        a4.callServerMethod(a4.getSurveyAction("UpdateEmailTemplate", "Distribute"), { templateId: templateId, subject: subject, htmlBody: htmlBody, textBody: textBody }, function () {
            emailDistributionWizard.currentTemplate = { Id: templateId, Name: name, Subject: subject, HTMLBody: a4.decodeHtml(htmlBody), TEXTBody: textBody };
            emailDistributionWizard.disableWizardNavigation(false);
            emailDistributionWizard.disableMessage(true);
        });
    },
    enableUnsavedChanges: function () {
        $(".v-template-unsavedChanges", this.context).a4unsavedChanges({
            elements: "#Subject, #TextBody, #HtmlBody",
            buttons: ".h-cancelTemplate, .h-saveTemplate",
            ignoreDisabledElements: false,
            ignoreHiddenElements: false,
            promptWhenLeavingPage: true
        });
    }
}

$(document).ready(function () {
    if (emailDistributionWizard.context.length > 0) {
        emailDistributionWizard.initialize();
        emailDistributionWizard.bindEvents();
        distributionWizard.initializeBase(emailDistributionWizard);
        distributionWizard.bindBaseEvents(emailDistributionWizard);

        // display text container in the beginning if it is not empty and html content is empty
        var textContent = $("#TextBody", emailDistributionWizard.context).val().trim();
        var htmlContent = $("#HtmlBody", emailDistributionWizard.context).val().trim();

        if (htmlContent == "" && textContent != "") {
            $(".h-emailContentTypeSelector li.selected[data-editor='html']", emailDistributionWizard.context).removeClass("selected");
            $(".h-emailContentTypeSelector li[data-editor='text']", emailDistributionWizard.context).addClass("selected");
            $(".v-contentContainer[data-editor='html']", emailDistributionWizard.context).hide();
            $(".v-contentContainer[data-editor='text']", emailDistributionWizard.context).show();
        }
    }
});